package w83b.w83bOperacionesPaso.w83bCitaciones;

import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bCitacionBean;
import w83b.w83bBeans.W83bPlantillasBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesRTF;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bRelacionAcuseCitacionAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		//String strRutaRtf ="";// Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_RTF")+"plantillaCertNumDelCentSind.rtf";
		

		W83bCitacionBean citacion=(W83bCitacionBean)contexto.get("w83bCitacionDetalleBean");
		HashMap txtMuniProv=(HashMap)contexto.get("w83bMapResultadosBean");
		
		String idioma=(String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
		W83bUsuarioXLNetsBean usuario=(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
	    HashMap datosDelDep=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);  	
        	
		HashMap mapaPar = new HashMap();
		
		HashMap mapaPlantillas = (HashMap)contexto.get("w83bPlantillasMap");
		byte[] plantilla = ((W83bPlantillasBean)mapaPlantillas.get(W83bClsConstantes.RELACUSES.toUpperCase())).getFichero();
		
		CharSequence content=W83bUtilidadesRTF.leerTodoFichero(plantilla);
		
		String contenido=content.toString();

		StringBuffer contenidoBuffer=new StringBuffer(contenido);
		int rep=contenido.indexOf("pnseclvl9");
		StringBuffer hastarep=new StringBuffer(contenido.substring(0,rep));
		int a=hastarep.lastIndexOf("pntxta )}}");
		int z=contenido.indexOf("themedata");
		StringBuffer parteDelanteLimpia=new StringBuffer(contenido.substring(0,a+10));
		String parteAtrasLimpia=contenido.substring(z-4,contenido.length());
		
		StringBuffer elemento=new StringBuffer(W83bClsConstantes.CUARENTA);
		StringBuffer datos=new StringBuffer();
		datos.append(parteDelanteLimpia);
		mapaPar.put("<<DEPEUS>>",((StringBuffer)datosDelDep.get("tituloDepEu")).toString());
		mapaPar.put("<<DEPCAS>>",((StringBuffer)datosDelDep.get("tituloDepEs")).toString());
		mapaPar.put("<<DELEUS>>",((StringBuffer)datosDelDep.get("tituloDelelegacionEu")).toString());
		mapaPar.put("<<DELCAS>>",((StringBuffer)datosDelDep.get("tituloDelelegacionEs")).toString());
		mapaPar.put("<<DIRDELEGACION>>",(String)datosDelDep.get("dirdelegacion"));
		String fecha="";
		if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
			fecha=W83bDateUtil.getInstance().getCurrentDateTime(W83bDateUtil.ES_PATTERN_HORA);
		}
		else{
			fecha=W83bDateUtil.getInstance().getCurrentDateTime(W83bDateUtil.EU_PATTERN_HORA);
		}
		
		mapaPar.put("<<DIA>>",fecha.substring(0, fecha.length()-3));
		
		int numElem=1;
		if(citacion.getCentroSel().equals(W83bClsConstantes.CONSTANTE_NO_VALIDADA))
		{
			mapaPar.put("<<ATTON>>",String.valueOf(numElem));
			mapaPar.put("<<RAZON>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajo().getRazonSocial()));
			mapaPar.put("<<NUMEXP>>",citacion.getNacta().substring(1,citacion.getNacta().length()));
			mapaPar.put("<<DOMIC>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajo().getDomicilio()));
			mapaPar.put("<<MUNIC>>",W83bUtilidadesRTF.ponerBlancoANulo(citacion.getCentroTrabajo().getMunicipio()));
			mapaPar.put("<<PROV>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajo().getTerritorio()));
		}else if(citacion.getCentroSel().equals(W83bClsConstantes.CONSTANTE_VALIDADA))
		{
			mapaPar.put("<<ATTON>>",String.valueOf(numElem));
			mapaPar.put("<<RAZON>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajo().getRazonSocial()));
			mapaPar.put("<<NUMEXP>>",citacion.getNacta().substring(1,citacion.getNacta().length()));
			mapaPar.put("<<DOMIC>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajoPrevOrig().getDomicilio()));
			mapaPar.put("<<MUNIC>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajoPrevOrig().getMunicipio()));
			mapaPar.put("<<PROV>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getCentroTrabajoPrevOrig().getTerritorio()));
		}
		mapaPar.put("<<NUMNOTIF>>",String.valueOf(numElem));
		elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBuffer, mapaPar);
		datos.append(elemento);
		//por el centro
		numElem++;
		if(citacion.getMesa().equals(W83bClsConstantes.CONSTANTE_VALIDADA))
		{
			mapaPar.put("<<RAZON>>",Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.comunicacion.mesaElectoral",idioma));
			//resto del mapa es el mismo que la empresa
			mapaPar.put("<<ATTON>>",String.valueOf(numElem));
			elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBuffer, mapaPar);
			datos.append(elemento);
			numElem++;
		}
		if(StringUtils.isNotEmpty(citacion.getDniImpug()))
			
		{  	
			mapaPar.put("<<ATTON>>",String.valueOf(numElem));
			mapaPar.put("<<RAZON>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getNombreImpug()));
			mapaPar.put("<<NUMEXP>>",citacion.getNacta().substring(1,citacion.getNacta().length()));
			mapaPar.put("<<DOMIC>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getDirImpug()));
			mapaPar.put("<<MUNIC>>",W83bUtilidadesRTF.ponerBlancoANulo(citacion.getMunicipioImpugTxtC()));
			mapaPar.put("<<PROV>>",W83bUtilidades.convertirAVasioSiNulo(citacion.getProvinciaImpugTxtC()));
			
			elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBuffer, mapaPar);
			
			datos.append(elemento);
			numElem++;
			
		}
		String [] cods=citacion.getCodsSindicatos().split(",");
		String [] siglas=citacion.getSiglasSindicatos().split(", ");
		String [] dir=citacion.getDirSindicatos().split(",");
		String [] munisC=(String[])txtMuniProv.get("txtMunicipiosC");
		String [] provsC=(String[])txtMuniProv.get("txtTerritoriosC");
		
		
		for(int i=0;i<cods.length;i++)
		{
			mapaPar.put("<<ATTON>>",String.valueOf(numElem));
			mapaPar.put("<<RAZON>>",W83bUtilidades.convertirAVasioSiNulo(siglas[i]));
			mapaPar.put("<<NUMEXP>>",citacion.getNacta().substring(1,citacion.getNacta().length()));
			mapaPar.put("<<DOMIC>>",W83bUtilidades.convertirAVasioSiNuloArray(dir,i));
			mapaPar.put("<<MUNIC>>",W83bUtilidades.convertirAVasioSiNuloArray(munisC,i));
			mapaPar.put("<<PROV>>",W83bUtilidades.convertirAVasioSiNuloArray(provsC,i));
			
			elemento=W83bUtilidadesRTF.sustituirCadenaCaracteresString(contenidoBuffer, mapaPar);
		
			datos.append(elemento);
			numElem++;
		}
		
		datos.append(parteAtrasLimpia);
		
		response.setContentType("application/msword");
        response.setContentLength(datos.toString().getBytes().length);
        
        response.setHeader("Content-disposition","attachment;filename=RelacionAcusesCitaciones.rtf");
       
        response.getOutputStream().write(datos.toString().getBytes());
        response.getOutputStream().flush();
        
        return null;
	    
	}

}

